<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Product Heading
 * Creates a product heading with optional subheadings.
 */
 
// Don't load directly
if ( !defined('ABSPATH') ) { die('-1'); }

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('prod_header', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_prod_header' ) ) 
{
	class avia_prod_header extends aviaShortcodeTemplate{
			
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Product Heading', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."prod-header.png";
				$this->config['order']		= 99;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'prod_header';
				$this->config['modal_data'] = array('modal_class' => 'largescreen');
				$this->config['tooltip'] 	= __('Creates a product heading with optional subheadings.', 'avia_framework' );
				$this->config['preview'] 	= false;
				$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
			}
			
			
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				global $product;
				$prod_title = $product->post->post_title;
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					 array(	
							"name" 	=> __("Heading Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of heading you want to display.", 'avia_framework' ),
							"id" 	=> "tag",
							"type" 	=> "select",
							"std" 	=> "h2",
							"subtype" => array("H1"=>'h1',"H2"=>'h2',"H3"=>'h3',"H4"=>'h4',"H5"=>'h5',"H6"=>'h6')
							), 
							
					
					array(	
							"name" 	=> __("Heading Style", 'avia_framework' ),
							"desc" 	=> __("Select a heading style", 'avia_framework' ),
							"id" 	=> "style",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Style", 'avia_framework' )=>'',  __("Heading Style Modern (left)", 'avia_framework' )=>'blockquote modern-quote' , __("Heading Style Modern (centered)", 'avia_framework' )=>'blockquote modern-quote modern-centered', __("Heading Style Classic (centered, italic)", 'avia_framework' )=>'blockquote classic-quote')
							),   
				            
							
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your Heading in Pixel", 'avia_framework' ),
				            "id" 	=> "size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(20,90,1, array( __("Default Size", 'avia_framework' )=>'')),
				            //"required" => array('style','not',''),
				            "std" => ""),
							
					array(	
							"name" 	=> __("Title Override", 'avia_framework' ),
							"desc" 	=> __("Here you can change the product title displayed. Leave blank to use the default product title.", 'avia_framework' ),
							"id" 	=> "new_title",
							"std" 	=> "",
							"type" 	=> "input"),
				            				            
				     array(	
							"name" 	=> __("Subheading", 'avia_framework' ),
							"desc" 	=> __("Add an extra descriptive subheading above or below the actual heading", 'avia_framework' ),
							"id" 	=> "subheading_active",
							"type" 	=> "select",
							"std" 	=> "",
				            //"required" => array('style','not',''),
							"subtype" => array( __("No Subheading", 'avia_framework' )=>'',  __("Display Subheading", 'avia_framework' )=>'subheading_below'),
							),  		
							
					array(	
							"name" 	=> __("Sub Heading Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of sub heading you want to display.", 'avia_framework' ),
							"id" 	=> "sub_head_type",
							"type" 	=> "select",
							"std" 	=> "short-desc",
							"required" => array('subheading_active','not',''),
							"subtype" => array("Product Short Description"=>'short-desc',"Units Sold Count"=>'sold-count',"Product Categories"=>'prod-cat',"Custom"=>'custom')
							), 	
													
					array(
								"name" 	=> "",
								"desc" 	=> __("In order to get the parent category, or categories, to show in your product URL you need to select ONLY the current level category for the product. In doing so, the parent category will not display in the subheading.  The field below allows you to manually set a parent category name.", 'avia_framework' ),
								"type" 	=> "heading",
								"required" => array('sub_head_type','equals','prod-cat'),
								"description_class" => "av-builder-note av-neutral",
								),	
							
					array(	
							"name" 	=> __("Parent Title", 'avia_framework' ),
							"desc" 	=> __("Set a custom title as a parent category in the subheading.", 'avia_framework' ),
							"id" 	=> "parent_title",
							"std" 	=> "",
							"required" => array('sub_head_type','equals','prod-cat'),
							"type" 	=> "input"),
							
					array(	
							"name" 	=> __("Category Links", 'avia_framework' ),
							"desc" 	=> __("Include links to each category archive?.", 'avia_framework' ),
							"id" 	=> "cat_links",
							"std" 	=> __("yes_links", 'avia_framework' ),
							"required" => array('sub_head_type','equals','prod-cat'),
							"type" 	=> "select",
							"subtype" => array( __("No Links", 'avia_framework' )=>'no_links',  __("Include Links", 'avia_framework' )=>'yes_links'),
							),				  
							  
					array(
						"name" 	=> __("Subheading Text",'avia_framework' ),
						"desc" 	=> __("Add your subheading here",'avia_framework' ),
						"id" 	=> "content",
						"type" 	=> "textarea",
						"required" => array('sub_head_type','equals','custom'),
						"std" 	=> ""),   
						
					array(	"name" 	=> __("Subheading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your subeading in Pixel", 'avia_framework' ),
				            "id" 	=> "subheading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(10,40,1),
				            "required" => array('subheading_active','not',''),
				            "std" => "16"), 
				            	
                    array(	"name" 	=> __("Padding Bottom", 'avia_framework' ),
							"desc" 	=> __("Bottom Padding in pixel", 'avia_framework' ),
				            "id" 	=> "padding",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,120,1),
				            "std" => "10"),  
				     
				    array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Heading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-heading')
						),
						
					array(	
							"name" 	=> __("Subheading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "subcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-subheading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_subfont",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('subcolor','equals','custom-color-subheading')
						),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
								
									
								array(
									"name" 	=> __("Heading Font Size",'avia_framework' ),
									"desc" 	=> __("Set the font size for the heading, based on the device screensize.", 'avia_framework' ),
									"type" 	=> "heading",
									"description_class" => "av-builder-note av-neutral",
									),
										
									array(	"name" 	=> __("Font Size for medium sized screens", 'avia_framework' ),
						            "id" 	=> "av-medium-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'' , __("Hidden", 'avia_framework' )=>'hidden' ), "px"),
						            "std" => ""),
						            
						            array(	"name" 	=> __("Font Size for small screens", 'avia_framework' ),
						            "id" 	=> "av-small-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
									array(	"name" 	=> __("Font Size for very small screens", 'avia_framework' ),
						            "id" 	=> "av-mini-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
						            
						        array(
									"name" 	=> __("Subheading Font Size",'avia_framework' ),
									"desc" 	=> __("Set the font size for the subheading, based on the device screensize.", 'avia_framework' ),
									"type" 	=> "heading",
									"description_class" => "av-builder-note av-neutral",
									),
										
									array(	"name" 	=> __("Font Size for medium sized screens", 'avia_framework' ),
						            "id" 	=> "av-medium-font-size",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
						            array(	"name" 	=> __("Font Size for small screens", 'avia_framework' ),
						            "id" 	=> "av-small-font-size",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
									array(	"name" 	=> __("Font Size for very small screens", 'avia_framework' ),
						            "id" 	=> "av-mini-font-size",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),    
				
							
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
					
				);

			}
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				
			    extract(shortcode_atts(array('tag' => 'h2', 'new_title' => '', 'padding' => '5', 'color'=>'', 'subcolor' =>'', 'style'=>'', 'custom_font'=>'', 'custom_subfont'=>'', 'size'=>'', 'subheading_active' => '', 'sub_head_type' => '', 'parent_title' => '', 'cat_links' => '', 'subheading_size'=>''), $atts, $this->config['shortcode']));
			
        		$output  = "";
        		$styling = "";
        		$subheading = "";
        		$border_styling = "";
        		$before = $after = "";
        		$class   = $meta['el_class'];
        		$subheading_extra = "";
        		

        			// add seo markup
                    $markup = avia_markup_helper(array('context' => 'entry_title','echo'=>false, 'custom_markup'=>$meta['custom_markup']));
					
					// filter heading for & symbol and convert them					
        			$heading = apply_filters('avia_ampersand', wptexturize($heading));
        			
        			//if the heading contains a strong tag make apply a custom class that makes the rest of the font appear smaller for a better effect
        			if( strpos($heading, '<strong>') !== false ) $class .= " av-thin-font";
					
					$new_title  = $atts['new_title'];
        			
        			//apply the padding bottom styling
	        		$styling .= "padding-bottom:{$padding}px;";
	        		
	        		// if the color is a custom hex value add the styling for both border and font
	        		if($color == "custom-color-heading" && $custom_font)  
	        		{
	        			$styling .= "color:{$custom_font};";
	        			$border_styling = "style='border-color:{$custom_font}'";
	        			$subheading_extra = "av_custom_color";
	        		}
					
					if($subcolor == "custom-color-subheading" && $custom_subfont)  
	        		{
	        			$substyling .= "color:{$custom_subfont} !important;";
	        		}
					
					if($suffix_color == "custom-color-suffix" && $custom_suffix)  
	        		{
						$suffix_styling .= "color:{$custom_suffix};";
					}
					
					if($border_color == "custom-color-border" && $custom_border)  
	        		{
						$border_styling .= "border-color:{$custom_border};";
					}
	        		
	        		// if a custom font size is set apply it to the container and also apply the inherit class so the actual heading uses the size
	        		if(!empty($style) && !empty($size)) { $styling .= "font-size:{$size}px;"; $class .= " av-inherit-size";}
	        		
	        		//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
	        		
	        		//check if we got a subheading
	        		if( !empty( $subheading_active ) && ($sub_head_type == 'custom') && !empty( $content ) )
	        		{
	        			
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'>".$content."</div>";
	        		
	        			$after = $content;
	        		}
					
					if( !empty( $subheading_active ) && ($sub_head_type == 'short-desc') )
	        		{
	        			global $product;
						$shortdesc = $product->post->post_excerpt;
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'>".$shortdesc."</div>";
	        		
	        				$after = $content;
	        		}
					
					if( !empty( $subheading_active ) && ($sub_head_type == 'sold-count') )
	        		{
	        			global $product;
						$units_sold = get_post_meta( $product->id, 'total_sales', true );
	        			$content = "<div class='sold-count av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}' itemprop='text' style='padding-bottom:5px;'> <span class='av_font_icon avia_animate_when_visible  0 av-icon-style-  av-no-color avia-icon-pos-left  avia_start_animation avia_start_delayed_animation'><span class='av-icon-char' aria-hidden='true' data-av_icon='' data-av_iconfont='entypo-fontello'></span></span><span style='font-weight:bold;'>UNITS SOLD:</span> ".$units_sold."</div>";

	        				$after = $content;
	        		}        	
				
				if( $sub_head_type != 'prod-cat' )
	        		{
				
	        		//html markup
					global $product;
					$prod_title = $product->post->post_title;
					if(!empty($new_title)) $prod_title = $new_title;
	        		$output .= "<div id='prodhead' class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$prod_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
	        		$output .= 		$after;
	        		$output .= "</div>";
        		
        		
        		return $output;
        		}
				
				if( ($sub_head_type == 'prod-cat') && ($cat_links == 'no_links') )
	        		{
				
	        		//html markup
					global $product;
					$prod_title = $product->post->post_title;
					$prod_cat = get_the_terms( $post->ID , 'product_cat');
					$parent_title  = $atts['parent_title'];
					if(!empty($new_title)) $prod_title = $new_title;
	        		$output .= "<div id='prodhead' class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$prod_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
	        		$output .= "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-variant: small-caps; text-transform:lowercase; margin-top:0px !important; font-size:{$subheading_size}px; {$substyling}'>";
					if(!empty($parent_title)){
					$output .= $parent_title.'<span class="parent-sep">&nbsp; &raquo; &nbsp;</span>';
					}
					foreach( $prod_cat as $category ) {
    				$output .= $category->name . '<span class="sep"> &middot; </span>';
					}
	        		$output .= "</div>";
	        		$output .= "</div>";
        		
        		
        		return $output;
        		}
				
				if( ($sub_head_type == 'prod-cat') && ($cat_links == 'yes_links') )
	        		{
				
	        		//html markup
					global $product;
					$prod_title = $product->post->post_title;
					$prod_cat = get_the_terms( $post->ID , 'product_cat');
					$parent_title  = $atts['parent_title'];
					if(!empty($new_title)) $prod_title = $new_title;
	        		$output .= "<div id='prodhead' class='av-special-heading av-special-heading-{$tag} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$prod_title."</{$tag}>";
	        		$output .= 		"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
	        		$output .= "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-variant: small-caps; text-transform:lowercase; margin-top:0px !important; font-size:{$subheading_size}px; {$substyling}'>";
					if(!empty($parent_title)){
					$output .= $parent_title.'<span class="parent-sep">&nbsp; &raquo; &nbsp;</span>';
					}
					foreach( $prod_cat as $category ) {
    				$output .= '<a href="'.get_term_link( $category ).'">'.$category->name . '</a><span class="sep"> &middot; </span>';
					}
	        		$output .= "</div>";
	        		$output .= "</div>";
        		
        		
        		return $output;
        		}
				
			}
	}
}
