<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Price Header
 * Displays the price of the product using the Enfold special heading style.
 */
 
// Don't load directly
if ( !defined('ABSPATH') ) { die('-1'); }

// adds the css 
add_action('wp_head','price_suffix_style');
function price_suffix_style( ){
	if(is_rtl()):
		echo '<style>small.price_suffix {padding-right:10px !important; font-size:60% !important;} .meta-border {border-color:#d54e21 !important;}</style>';
	else:
		echo '<style>small.price_suffix {padding-left:10px !important; font-size:60% !important;} .meta-border {border-color:#d54e21 !important;}</style>';
	endif;
	echo '<style>@media only screen and (max-width: 767px){ small.price_suffix {display:block !important; padding-left:0px !important;} }</style>';
	echo '<style>@media only screen and (min-width: 767px){ small.price_suffix {vertical-align:top !important;} }</style>';
	}

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('wc_price_header', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_wc_price_header' ) ) 
{
	class avia_wc_price_header extends aviaShortcodeTemplate{
			
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Price Heading', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."price-tag.png";
				$this->config['order']		= 98;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'wc_price_header';
				$this->config['modal_data'] = array('modal_class' => 'largescreen');
				$this->config['tooltip'] 	= __('Creates a header with the product price.', 'avia_framework' );
				$this->config['preview'] 	= false;
				$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
			}
			
			
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(	
						"name" 	=> __("Price Prefix", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed before the poduct price.", 'avia_framework' ),
						"id" 	=> "heading",
						"std" 	=> __("Starting at only", 'avia_framework' ),
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Price Suffix", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed after the product price.<br /><strong>Example:</strong> per yard, each, etc.", 'avia_framework' ),
						"id" 	=> "suffix",
						"std" 	=> "",
						"type" 	=> "input"),
						
					 array(	
							"name" 	=> __("Heading Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of heading you want to display.", 'avia_framework' ),
							"id" 	=> "tag",
							"type" 	=> "select",
							"std" 	=> "h2",
							"subtype" => array("H1"=>'h1',"H2"=>'h2',"H3"=>'h3',"H4"=>'h4',"H5"=>'h5',"H6"=>'h6')
							), 
					
					array(	
							"name" 	=> __("Heading Style", 'avia_framework' ),
							"desc" 	=> __("Select a heading style", 'avia_framework' ),
							"id" 	=> "style",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Style", 'avia_framework' )=>'',  __("Heading Style Modern (left)", 'avia_framework' )=>'blockquote modern-quote' , __("Heading Style Modern (centered)", 'avia_framework' )=>'blockquote modern-quote modern-centered', __("Heading Style Classic (centered, italic)", 'avia_framework' )=>'blockquote classic-quote')
							),   
							
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your Heading in Pixel", 'avia_framework' ),
				            "id" 	=> "size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(20,90,1, array( __("Default Size", 'avia_framework' )=>'')),
				            "std" => ""),
							
					array(	
							"name" 	=> __("Pricing Display", 'avia_framework' ),
							"desc" 	=> __("Select which style you would like the price displayed. Superscripted will output anything after a decimal point smaller and placed higher.  The look of this effect will vary based on your current CSS and font being used.  You can style this element to suit your needs by editing the class of '.price_sup' in your child theme CSS.<br /><strong>Example:</strong> $32.50 will be displayed as $32<sup>50</sup>.", 'avia_framework' ),
							"id" 	=> "price_style",
							"type" 	=> "select",
							"std" 	=> "inline",
							"subtype" => array("Inline"=>'inline',"Superscripted"=>'superscripted')
							), 
							
					array(	
							"name" 	=> __("Subheading", 'avia_framework' ),
							"desc" 	=> __("Add an extra descriptive subheading above or below the actual heading", 'avia_framework' ),
							"id" 	=> "subheading_active",
							"type" 	=> "select",
							"std" 	=> "",
				            //"required" => array('style','not',''),
							"subtype" => array( __("No Subheading", 'avia_framework' )=>'',  __("Display Subheading", 'avia_framework' )=>'subheading_below'),
							),  		
							
					array(	
							"name" 	=> __("Sub Heading Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of sub heading you want to display.", 'avia_framework' ),
							"id" 	=> "sub_head_type",
							"type" 	=> "select",
							"std" 	=> "short-desc",
							"required" => array('subheading_active','not',''),
							"subtype" => array("Product Short Description"=>'short-desc',"Units Sold Count"=>'sold-count',"Pruduct Categories"=>'prod-cat',"Custom"=>'custom')
							), 
							
					array(
								"name" 	=> "",
								"desc" 	=> __("In order to get the parent category, or categories, to show in your product URL you need to select ONLY the current level category for the product. In doing so, the parent category will not display in the subheading.  The field below allows you to manually set a parent category name.", 'avia_framework' ),
								"type" 	=> "heading",
								"required" => array('sub_head_type','equals','prod-cat'),
								"description_class" => "av-builder-note av-neutral",
								),	
							
					array(	
							"name" 	=> __("Parent Title", 'avia_framework' ),
							"desc" 	=> __("Set a custom title as a parent category in the subheading.", 'avia_framework' ),
							"id" 	=> "parent_title",
							"std" 	=> "",
							"required" => array('sub_head_type','equals','prod-cat'),
							"type" 	=> "input"),	
							
					array(	
							"name" 	=> __("Category Links", 'avia_framework' ),
							"desc" 	=> __("Include links to each category archive?.", 'avia_framework' ),
							"id" 	=> "cat_links",
							"std" 	=> __("yes_links", 'avia_framework' ),
							"required" => array('sub_head_type','equals','prod-cat'),
							"type" 	=> "select",
							"subtype" => array( __("No Links", 'avia_framework' )=>'no_links',  __("Include Links", 'avia_framework' )=>'yes_links'),
							),					  
							  
					array(
						"name" 	=> __("Subheading Text",'avia_framework' ),
						"desc" 	=> __("Add your subheading here",'avia_framework' ),
						"id" 	=> "content",
						"type" 	=> "textarea",
						"required" => array('sub_head_type','equals','custom'),
						"std" 	=> ""),   
						
					array(	"name" 	=> __("Subheading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your subeading in Pixel", 'avia_framework' ),
				            "id" 	=> "subheading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(10,40,1),
				            "required" => array('sub_head_type','not','sold-count'),
				            "std" => "16"), 
				            				            
                    array(	"name" 	=> __("Padding Bottom", 'avia_framework' ),
							"desc" 	=> __("Bottom Padding in pixel", 'avia_framework' ),
				            "id" 	=> "padding",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,120,1),
				            "std" => "10"),  
				     
				    array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Heading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-heading')
						),
						
				    array(	
							"name" 	=> __("Suffix Color", 'avia_framework' ),
							"desc" 	=> __("Select a suffix color", 'avia_framework' ),
							"id" 	=> "suffix_color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-suffix', __("Custom Color", 'avia_framework' )=>'custom-color-suffix')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_suffix",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('suffix_color','equals','custom-color-suffix')
						),
						
					array(	
							"name" 	=> __("Subheading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "subcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-subheading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_subfont",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('subcolor','equals','custom-color-subheading')
						),
						
					array(	
							"name" 	=> __("Border Color", 'avia_framework' ),
							"desc" 	=> __("Select a border color", 'avia_framework' ),
							"id" 	=> "border_color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-border', __("Custom Color", 'avia_framework' )=>'custom-color-border')
							), 
					
					array(	
							"name" 	=> __("Custom Border Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_border",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('border_color','equals','custom-color-border')
						),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
								array(
									"name" 	=> __("Heading Font Size",'avia_framework' ),
									"desc" 	=> __("Set the font size for the heading, based on the device screensize.", 'avia_framework' ),
									"type" 	=> "heading",
									"description_class" => "av-builder-note av-neutral",
									),
										
									array(	"name" 	=> __("Font Size for medium sized screens", 'avia_framework' ),
						            "id" 	=> "av-medium-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'' , __("Hidden", 'avia_framework' )=>'hidden' ), "px"),
						            "std" => ""),
						            
						            array(	"name" 	=> __("Font Size for small screens", 'avia_framework' ),
						            "id" 	=> "av-small-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
									array(	"name" 	=> __("Font Size for very small screens", 'avia_framework' ),
						            "id" 	=> "av-mini-font-size-title",
						            "type" 	=> "select",
						            "subtype" => AviaHtmlHelper::number_array(10,120,1, array( __("Default", 'avia_framework' )=>'', __("Hidden", 'avia_framework' )=>'hidden'), "px"),
						            "std" => ""),
						            
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				);
			}
			 
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				global $product;
				$price = $product->get_price();
				$price = explode('.', $price);
				$currency .= get_woocommerce_currency_symbol();
				$currency = "<sup style='position:relative;font-size:60%;top:-0.5em;vertical-align:baseline;'>".$currency."</sup>";
				
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				
			    extract(shortcode_atts(array('tag' => 'h2', 'padding' => '5', 'heading'=>'', 'suffix'=>'', 'price_style' => '', 'color'=>'', 'subcolor'=>'', 'border_color'=>'', 'suffix_color'=>'', 'style'=>'', 'custom_font'=>'', 'subheading_active' => '', 'parent_title' => '', 'custom_subfont'=>'', 'custom_suffix'=>'', 'sub_head_type' => '', 'subheading_size'=>'', 'custom_border'=>'', 'size'=>'', 'cat_links'=>''), $atts, $this->config['shortcode']));
			
        		$output  = "";
        		$styling = "";
        		$border_styling = "";
        		$before = $after = "";
        		$class   = $meta['el_class'];
        		
        		if($heading)
        		{
        			// add seo markup
                    $markup = avia_markup_helper(array('context' => 'entry_title','echo'=>false, 'custom_markup'=>$meta['custom_markup']));
					
					// filter heading for & symbol and convert them					
        			$heading = apply_filters('avia_ampersand', wptexturize($heading));
        			
        			//if the heading contains a strong tag make apply a custom class that makes the rest of the font appear smaller for a better effect
        			if( strpos($heading, '<strong>') !== false ) $class .= " av-thin-font";
        			
        			//apply the padding bottom styling
	        		$padstyling .= "padding-bottom:{$padding}px; margin-top:0px !important;";
	        		
	        		// if the color is a custom hex value add the styling for both border and font
	        		if($color == "custom-color-heading" && $custom_font)  
	        		{
	        			$styling .= "color:{$custom_font};";
	        		}
					
	        		if($subcolor == "custom-color-subheading" && $custom_subfont)  
	        		{
	        			$substyling .= "color:{$custom_subfont} !important;";
	        		}
					
					if($suffix_color == "custom-color-suffix" && $custom_suffix)  
	        		{
						$suffix_styling .= "color:{$custom_suffix};";
					}
					
					if($border_color == "custom-color-border" && $custom_border)  
	        		{
						$border_styling .= "border-color:{$custom_border};";
					}
	        		
	        		// if a custom font size is set apply it to the container and also apply the inherit class so the actual heading uses the size
	        		if(!empty($size)) { $styling .= "font-size:{$size}px;"; $class .= " av-inherit-size";}
	        		
	        		//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
					
					//finish up the suffix styling string
	        		if(!empty($suffix_styling)) $suffix_styling = "style='{$suffix_styling}'";
					
					//finish up the border styling string
	        		if(!empty($border_styling)) $border_styling = "style='{$border_styling}'";
					if(($tag == "h1") && ($price_style == "inline")){$border_adjust .= "height:2.5em;";}
					if(($tag == "h2") && ($price_style == "inline")){$border_adjust .= "height:2em;";}
					if(($tag == "h3") && ($price_style == "inline")){$border_adjust .= "height:1.5em;";}
					if(($tag == "h4") && ($price_style == "inline")){$border_adjust .= "height:1.5em;";}
					if(($tag == "h5") && ($price_style == "inline")){$border_adjust .= "height:1.1em;";}
					if(($tag == "h6") && ($price_style == "inline")){$border_adjust .= "height:1.1em;";}
					
					if(($tag == "h1") && ($price_style == "superscripted")){$border_adjust .= "height:3em;";}
					if(($tag == "h2") && ($price_style == "superscripted")){$border_adjust .= "height:2.5em;";}
					if(($tag == "h3") && ($price_style == "superscripted")){$border_adjust .= "height:2em;";}
					if(($tag == "h4") && ($price_style == "superscripted")){$border_adjust .= "height:2em;";}
					if(($tag == "h5") && ($price_style == "superscripted")){$border_adjust .= "height:1.4em;";}
					if(($tag == "h6") && ($price_style == "superscripted")){$border_adjust .= "height:1.4em;";}
					if(!empty($border_adjust)) $border_adjust = "style='{$border_adjust}'";
	        		
					//finish up the suffix styling string
					if ($suffix) $price_suffix = "<small class='price_suffix' {$suffix_styling}>{$suffix}</small>";
					
					//check if we got a subheading
	        		if( !empty( $subheading_active ) && ($sub_head_type == 'custom') && !empty( $content ) )
	        		{
	        			
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'>".ShortcodeHelper::avia_apply_autop(ShortcodeHelper::avia_remove_autop($content) )."</div>";
	        		
	        			$after = $content;
	        		}
					
					if( !empty( $subheading_active ) && ($sub_head_type == 'short-desc') )
	        		{
	        			global $product;
						$shortdesc = $product->post->post_excerpt;
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='margin-top:1em !important; line-height:1.65em !important; font-size:{$subheading_size}px; {$substyling}'>".ShortcodeHelper::avia_apply_autop(ShortcodeHelper::avia_remove_autop($shortdesc) )."</div>";
	        		
	        				$after = $content;
	        		}
					
					if( !empty( $subheading_active ) && ($sub_head_type == 'sold-count') )
	        		{
	        			global $product;
						$units_sold = get_post_meta( $product->id, 'total_sales', true );
	        			$content = "<div class='sold-count ".$av_display_classes."' itemprop='text' style='padding-bottom:5px; padding-top:10px;'> <span class='av_font_icon avia_animate_when_visible  0 av-icon-style-  av-no-color avia-icon-pos-left  avia_start_animation avia_start_delayed_animation'><span class='av-icon-char' aria-hidden='true' data-av_icon='' data-av_iconfont='entypo-fontello'></span></span><span style='font-weight:bold;'>UNITS SOLD:</span> ".$units_sold."</div>";

	        				$after = $content;
	        		}
					
					if( !empty( $subheading_active ) && ($sub_head_type == 'prod-cat') )
	        		{
	        			global $product;
						$prod_cat = get_the_terms( $post->ID , 'product_cat');
						$parent_title  = $atts['parent_title'];
						if(!empty($parent_title)){
						$parentcat = $parent_title.'<span class="parent-sep">&nbsp; &raquo; &nbsp;</span>';
						}
						if($cat_links == 'no_links'){
						foreach( $prod_cat as $category ) {
    					$prodcats = $category->name . '<span class="sep"> &middot; </span>';
						}
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-variant: small-caps; text-transform:lowercase; margin-top:10px !important; font-size:{$subheading_size}px; {$substyling}'><strong>".$parentcat.$prodcats."</strong></div>";
						}
						if($cat_links == 'yes_links'){
						foreach( $prod_cat as $category ) {
    					$prodcats = '<a href="'.get_term_link( $category ).'">'.$category->name . '</a><span class="sep"> &middot; </span>';
						}
	        			$content = "<div class ='av-subheading av-{$subheading_active} {$subheading_extra} {$av_font_classes}' style='font-variant: small-caps; text-transform:lowercase; margin-top:10px !important; font-size:{$subheading_size}px; {$substyling}'><strong>".$parentcat.$prodcats."</strong></div>";
						}
	        				$after = $content;
	        		}
					
					if ($price_style == 'inline'){
					$price = $product->get_price();
					$productprice = $currency.$price;	
					}
					if ($price_style == 'superscripted'){
					$price = $product->get_price();
					$price = explode('.', $price);
					$productprice = $currency.$price[0]."<sup style='position:relative;font-size:60%;top:-0.5em;vertical-align:baseline;'>".$price[1]."</sup>";
					}
	        	
	        		//html markup
	        		$output .= "<div style='{$padstyling}' class='price-header av-special-heading av-special-heading-{$tag} {$color} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 		"<{$tag} class='av-special-heading-tag {$suffix_color} {$av_title_font_classes}' {$styling} $markup >{$heading} ".$productprice."{$price_suffix}</{$tag}>";
	        		$output .= 		"<div class='special-heading-border' {$border_adjust}><div class='special-heading-inner-border {$border_color}' {$border_styling}></div></div>";
	        		$output .= 		$after;
	        		$output .= "</div>";
        		}
        		
        		return $output;
        	}
			
	}
}
