<?php
/**
 * User Templates Empty State Template.
 *
 * @since 1.8.8
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wpforms-admin-empty-state-container wpforms-admin-no-user-templates">

	<h2 class="waving-hand-emoji">
		<?php esc_html_e( 'Hi there!', 'wpforms-lite' ); ?>
	</h2>

	<h4><?php esc_html_e( 'آیا می دانستید که می توانید فرم های خود را به عنوان قالب های قابل استفاده مجدد ذخیره کنید؟', 'wpforms-lite' ); ?></h4>
	<p><?php esc_html_e( 'فرم های سفارشی خود را برای استفاده سریع و آسان در کتابخانه الگوها ذخیره کنید.', 'wpforms-lite' ); ?></p>

	<img src="<?php echo esc_url( WPFORMS_PLUGIN_URL . 'assets/images/empty-states/no-user-templates.png' ); ?>" alt="">

	<p class="wpforms-admin-no-forms-footer">
		<?php
		printf(
			wp_kses( /* translators: %s - URL to the documentation article. */
				__( 'در صورت نیاز به پشتیبانی? مستندات مارا بررسی کنید <a href="%s" rel="noopener noreferrer" target="_blank">مشاهده مستندات</a>.', 'wpforms-lite' ),
				[
					'a' => [
						'href'   => [],
						'rel'    => [],
						'target' => [],
					],
				]
			),
			esc_url(
				wpforms_utm_link(
					'https://wpforms.com/docs/how-to-create-a-custom-form-template/',
					wpforms_is_admin_page( 'builder' ) ? 'builder-templates' : 'Form Templates Subpage',
					'User Templates Documentation'
				)
			)
		);
		?>
	</p>

</div>
