<?php
/*
Plugin Name: Banner Viewer By Mohammad Norouzi
Description: Display Banner Desktop And Mobile Responsivibility
Version: 1.0
Author: Mohammad Norouzi
Plugin URI:  https://ramanet.ir
Author URI:  https://ramanet.ir
Use Short Code : Banner , Thanks  a lot Mohammad Norouzi
*/
// 1. Add admin menu for banner settings
add_action('admin_menu', function () {
    add_menu_page('Benar Banner Settings', 'Benar Banner', 'manage_options', 'benar-banner', 'benar_banner_settings_page');
});

// 2. Register settings
add_action('admin_init', function () {
    register_setting('benar_banner_settings', 'benar_banner_desktop');
    register_setting('benar_banner_settings', 'benar_banner_mobile');
});

function benar_banner_settings_page() {
    ?>
    <div class="wrap">
        <h1>تنظیمات بنر Benar Banner</h1>
        <form method="post" action="options.php">
            <?php settings_fields('benar_banner_settings'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">تصویر دسکتاپ:</th>
                    <td><input type="text" name="benar_banner_desktop" value="<?php echo esc_attr(get_option('benar_banner_desktop')); ?>" style="width: 80%" />
                        <br><small>URL تصویر یا از کتابخانه رسانه کپی کنید</small></td>
                </tr>
                <tr valign="top">
                    <th scope="row">تصویر موبایل:</th>
                    <td><input type="text" name="benar_banner_mobile" value="<?php echo esc_attr(get_option('benar_banner_mobile')); ?>" style="width: 80%" />
                        <br><small>URL تصویر یا از کتابخانه رسانه کپی کنید</small></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// 3. Enqueue styles and JS
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('benar-banner-style', plugin_dir_url(__FILE__) . 'style.css');
    wp_enqueue_script('benar-banner-script', plugin_dir_url(__FILE__) . 'script.js', [], false, true);
});

// 4. Output banner just after <body> tag if homepage
add_action('wp_body_open', function () {
    if (!is_front_page()) return;
    if (isset($_COOKIE['benar_banner_closed']) && $_COOKIE['benar_banner_closed'] === 'true') return;

    $desktop = esc_url(get_option('benar_banner_desktop'));
    $mobile = esc_url(get_option('benar_banner_mobile'));
    ?>
    <div id="benar-banner" class="benar-visible">
        <button class="benar-close" aria-label="بستن بنر">×</button>
        <img src="<?php echo $desktop; ?>" class="benar-desktop" alt="desktop banner">
        <img src="<?php echo $mobile; ?>" class="benar-mobile" alt="mobile banner">
    </div>
    <?php
});
?>